#ifdef GL_ES
    precision mediump float;
#endif

varying vec4 v_color;
varying vec2 v_texCoords;
uniform sampler2D u_texture;
uniform float u_time;

void main() {
    // Curved CRT screen effect (barrel distortion)
    vec2 uv = v_texCoords - 0.5;
    float dist = length(uv);
    float barrel = 0.15;
    uv = uv * (1.0 + barrel * dist * dist);
    vec2 curvedUV = uv + 0.5;
    
    // Sample with distortion
    vec4 color = texture2D(u_texture, clamp(curvedUV, 0.0, 1.0)) * v_color;
    
    // Phosphor RGB mask (CRT pixel pattern)
    vec2 pixelPos = gl_FragCoord.xy;
    float maskR = 0.5 + 0.5 * sin(3.14159 * pixelPos.x / 3.0);
    float maskG = 0.5 + 0.5 * sin(3.14159 * (pixelPos.x + 1.0) / 3.0);
    float maskB = 0.5 + 0.5 * sin(3.14159 * (pixelPos.x + 2.0) / 3.0);
    
    // Apply RGB mask with intensity
    float maskIntensity = 0.1;
    color.r *= mix(1.0, maskR, maskIntensity);
    color.g *= mix(1.0, maskG, maskIntensity);
    color.b *= mix(1.0, maskB, maskIntensity);
    
    // Scanlines - dark and bright lines
    float scanLines = sin(curvedUV.y * 1200.0) * 0.08;
    float scanLines2 = sin(curvedUV.y * 600.0 + u_time * 2.0) * 0.02;
    color.rgb += vec3(scanLines + scanLines2);
    
    // Vignette with rounded corners
    vec2 vignetteUV = curvedUV * (1.0 - curvedUV.yx);
    float vignette = vignetteUV.x * vignetteUV.y * 15.0;
    vignette = clamp(vignette, 0.0, 1.0);
    vignette = smoothstep(0.0, 1.0, vignette);
    color.rgb *= vignette * 0.9 + 0.1;
    
    // Bloom/glow on bright areas
    float brightness = dot(color.rgb, vec3(0.299, 0.587, 0.114));
    if (brightness > 0.7) {
        color.rgb *= 1.1;
        color.rgb += vec3(0.05, 0.03, 0.01);
    }
    
    // Subtle horizontal blur (simulating CRT horizontal lines)
    vec2 blurUV = curvedUV;
    blurUV.x += sin(curvedUV.y * 100.0 + u_time) * 0.001;
    vec4 blurColor = texture2D(u_texture, blurUV) * v_color;
    color = mix(color, blurColor, 0.1);
    
    // Screen curvature darkening at edges
    float edgeDark = 1.0 - dist * 0.6;
    edgeDark = clamp(edgeDark, 0.7, 1.0);
    color.rgb *= edgeDark;
    
    // Subtle color bleeding (RGB separation)
    vec2 bleedOffset = vec2(0.002, 0.0);
    vec4 bleedR = texture2D(u_texture, clamp(curvedUV + bleedOffset, 0.0, 1.0)) * v_color;
    vec4 bleedB = texture2D(u_texture, clamp(curvedUV - bleedOffset, 0.0, 1.0)) * v_color;
    color.r = mix(color.r, bleedR.r, 0.3);
    color.b = mix(color.b, bleedB.b, 0.3);
    
    // Static noise (very subtle)
    float noise = fract(sin(dot(curvedUV, vec2(12.9898, 78.233))) * 43758.5453);
    noise = (noise - 0.5) * 0.015;
    color.rgb += vec3(noise);
    
    // Saturation boost
    vec3 luminance = vec3(dot(color.rgb, vec3(0.299, 0.587, 0.114)));
    color.rgb = mix(luminance, color.rgb, 1.2);
    
    gl_FragColor = color;
}